// Bu dosya, sitenin interaktif özelliklerini yönetecek.
document.addEventListener('DOMContentLoaded', function() {
    // Başlangıç tarihi
    const startDate = new Date('2025-08-05');
    const today = new Date();
    
    // Zaman farkını milisaniye cinsinden al
    const timeDiff = today.getTime() - startDate.getTime();
    
    // Milisaniyeyi güne çevir
    const daysPassed = Math.floor(timeDiff / (1000 * 60 * 60 * 24));
    
    // Sayaç elementini güncelle
    const daysCounter = document.getElementById('daysCounter');
    if (daysCounter) {
        daysCounter.innerText = daysPassed;
    }

    // URL'deki bildirimleri birkaç saniye sonra kaldır
    if (window.location.search.includes('saved=1')) {
        setTimeout(() => {
            const cleanUrl = window.location.href.split('?')[0];
            window.history.replaceState({}, document.title, cleanUrl);
        }, 3000); // 3 saniye sonra
    }
});
